'From Squeak4.3 of 22 December 2011 [latest update: #11860] on 7 September 2012 at 1:39:05 pm'!
BorderedMorph subclass: #BouncingBallMorph
	instanceVariableNames: 'x y dx dy radius ballColor'
	classVariableNames: 'DefBallColor DefColor MaxSpeed'
	poolDictionaries: ''
	category: 'Morphic-Examples'!

!BouncingBallMorph methodsFor: 'initialization' stamp: 'DY 2/8/2011 10:58'!
initialize
	super initialize.
	color := DefColor.
	ballColor := DefBallColor.
	x := 0.
	y := 0.
	dx := 0.
	dy := 0.
	! !

!BouncingBallMorph methodsFor: 'initialization' stamp: 'DY 2/8/2011 11:04'!
openInWorld
	| ran |
	super openInWorld.
	self bounds: self world bounds.
	ran := Random new.
	radius := 10 + (ran next * 21) asInteger.
	x := (self bounds extent x - (2*radius)) * ran next + radius.
	y := (self bounds extent y - (2*radius)) * ran next + radius.
	dx := ((2*MaxSpeed + 1) * ran next) asInteger - MaxSpeed.
	dy := ((2*MaxSpeed + 1) * ran next) asInteger - MaxSpeed.
	(dx = 0) & (dy = 0) ifTrue: [dx := 1. dy := 1].! !


!BouncingBallMorph methodsFor: 'drawing' stamp: 'DY 2/8/2011 11:08'!
drawOn: aCanvas
	| rect |
	super drawOn: aCanvas.
	rect := Rectangle
				center:  ((x@y) + self bounds origin)
				extent: (2*radius)@(2*radius).
	aCanvas fillOval: rect color: ballColor.
	aCanvas frameOval: rect color: Color black.
	! !


!BouncingBallMorph methodsFor: 'accessing - properties' stamp: 'DY 2/8/2011 11:13'!
ballColor
	^ballColor! !

!BouncingBallMorph methodsFor: 'accessing - properties' stamp: 'DY 2/8/2011 11:13'!
ballColor: newColor
	ballColor := newColor! !


!BouncingBallMorph methodsFor: 'event handling' stamp: 'DY 2/8/2011 11:12'!
step
	x := (x + (dx * (self stepTime / 1000))) asFloat.
	y := (y + (dy * (self stepTime / 1000))) asFloat.
	x + radius >= self bounds extent x ifTrue: [dx := dx negated].
	x - radius <= 0 ifTrue: [dx := dx negated].
	y + radius >= self bounds extent y ifTrue: [dy := dy negated].
	y - radius <= 0 ifTrue: [dy := dy negated].
	self changed.! !

!BouncingBallMorph methodsFor: 'event handling' stamp: 'DY 2/8/2011 11:08'!
stepTime
	^50.! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

BouncingBallMorph class
	instanceVariableNames: ''!

!BouncingBallMorph class methodsFor: 'instance creation' stamp: 'DY 2/8/2011 10:56'!
new
	DefColor := Color white.
	DefBallColor := Color yellow.
	MaxSpeed := 200.
	^super new.! !
